$(document).ready(function() {

  $('ul.timeline li a').click(function() {
    var $this = $(this);
    $('ul.timeline li').removeClass('active');
    $this.closest('li').addClass('active');

    $('.globus-item').removeClass('active');

    var btnClass = $this.attr("class");

    switch (btnClass) {
      case 'btn1915' : $('#globus1915').addClass('active'); transition(74); break;
      case 'btn1935' : $('#globus1935').addClass('active'); transition(41); break;
      case 'btn1937' : $('#globus1937').addClass('active'); transition(30); break;
      case 'btn1962' : $('#globus1962').addClass('active'); transition(171); break;
      case 'btn1963' : $('#globus1963').addClass('active'); transition(173); break;
      case 'btn1982' : $('#globus1982').addClass('active'); transition(75); break;
      case 'btn1988' : $('#globus1988').addClass('active'); transition(76); break;
      case 'btn1995' : $('#globus1995').addClass('active'); transition(82); break;
      case 'btn2013' : $('#globus2013').addClass('active'); transition(153); break;
    } 
  });
});

var diameter = 360,  
    radius = diameter/2;

var projection = d3.geo.orthographic()
    .scale(radius - 2)
    .translate([radius, radius])
    .clipAngle(90);

var canvas = d3.select("#globe")
  .attr("width", diameter)
  .attr("height", diameter);

var c = canvas.node().getContext("2d");

var path = d3.geo.path()
    .projection(projection)
    .context(c);

var title = d3.select(".globetext");

var globe,
    land,
    countries,
    borders,
    i,
    n;


d3.json("world-110m.json", function(error, topo) {
  globe = {type: "Sphere"};
  land = topojson.feature(topo, topo.objects.land);
  countries = topojson.feature(topo, topo.objects.countries).features;
  borders = topojson.mesh(topo, topo.objects.countries, function(a, b) { return a !== b; });

  transition(74);

});







  function transition(k) {
    d3.transition()
        .duration(900)
        .tween("rotate", function() {
          var p = d3.geo.centroid(countries[k]),
              r = d3.interpolate(projection.rotate(), [-p[0], -p[1]]);
          return function(t) {
            projection.rotate(r(t));
            c.clearRect(0, 0, diameter, diameter);
            c.fillStyle = "#d0d1d3", c.beginPath(), path(land), c.fill();
            c.fillStyle = "#934b38", c.beginPath(), path(countries[k]), c.fill();
            c.strokeStyle = "#fff", c.lineWidth = .5, c.beginPath(), path(borders), c.stroke();
            c.strokeStyle = "#000", c.lineWidth = 1, c.beginPath(), path(globe), c.stroke();
          };
        });
      
  };